/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Iterator;
import java.util.TreeMap;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transpose
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -2749226948849267413L;
    private int swap1 = 0;
    private int swap2 = 1;
    private final long[] size;

    public Transpose(Matrix m) {
        this(m, 0, 1);
    }

    public Transpose(Matrix m, int swap1, int swap2) {
        super(m);
        this.swap1 = swap1;
        this.swap2 = swap2;
        this.size = Coordinates.transpose(this.getSource().getSize(), swap1, swap2);
        if (this.getMetaData() != null) {
            this.setMetaData(Transpose.transposeAnnotation(m.getMetaData(), this.size, swap1, swap2));
        }
    }

    public static MapMatrix<String, Object> transposeAnnotation(MapMatrix<String, Object> aorig, long[] newSize, int swap1, int swap2) {
        if (aorig != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>(new TreeMap());
            a.put("Label", aorig.get("Label"));
            for (int i = 0; i < newSize.length; ++i) {
                Matrix am = (Matrix)aorig.get("DimensionMetaData" + i);
                if (am == null) continue;
                am = am.transpose(Calculation.Ret.NEW, swap1, swap2);
                if (i == swap1) {
                    a.put("DimensionMetaData" + swap2, am);
                    continue;
                }
                if (i == swap2) {
                    a.put("DimensionMetaData" + swap1, am);
                    continue;
                }
                a.put("DimensionMetaData" + i, am);
            }
            return a;
        }
        return null;
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.getSource().getAsObject(Coordinates.transpose(coordinates, this.swap1, this.swap2));
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.getSource().containsCoordinates(Coordinates.transpose(coordinates, this.swap1, this.swap2));
    }

    public boolean isSparse() {
        return this.getSource().isSparse();
    }

    public long getValueCount() {
        return this.getSource().getValueCount();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new Iterable<long[]>(){

            @Override
            public Iterator<long[]> iterator() {
                return new TransposedIterator();
            }
        };
    }

    public static MapMatrix<String, Object> transposeAnnotation(MapMatrix<String, Object> annotation, long[] newSize) {
        return Transpose.transposeAnnotation(annotation, newSize, 0, 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransposedIterator
    implements Iterator<long[]> {
        private final Iterator<long[]> iterator;

        TransposedIterator() {
            this.iterator = Transpose.this.getSource().availableCoordinates().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public long[] next() {
            return Coordinates.transpose(this.iterator.next(), Transpose.this.swap1, Transpose.this.swap2);
        }

        @Override
        public void remove() {
        }
    }
}

