/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultNamespace;
import org.dom4j.tree.NamespaceCache;

public class Namespace
extends AbstractNode {
    protected static final NamespaceCache cache = new NamespaceCache();
    public static final Namespace XML_NAMESPACE = cache.get("xml", "http://www.w3.org/XML/1998/namespace");
    public static final Namespace NO_NAMESPACE = cache.get("", "");
    private String prefix;
    private String uri;
    private int hashCode;

    public Namespace(String prefix, String uri) {
        this.prefix = prefix != null ? prefix : "";
        this.uri = uri != null ? uri : "";
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String asXML() {
        StringBuffer asxml = new StringBuffer(10);
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            asxml.append("xmlns:");
            asxml.append(prefix);
            asxml.append("=\"");
        } else {
            asxml.append("xmlns=\"");
        }
        asxml.append(this.getURI());
        asxml.append("\"");
        return asxml.toString();
    }

    protected int createHashCode() {
        int hashCode = this.uri.hashCode() ^ this.prefix.hashCode();
        if (hashCode == 0) {
            hashCode = 47806;
        }
        return hashCode;
    }

    protected Node createXPathResult(Element parent) {
        return new DefaultNamespace(parent, this.getPrefix(), this.getURI());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Namespace) {
            Namespace that = (Namespace)object;
            if (this.hashCode() == that.hashCode()) {
                return this.uri.equals(that.getURI()) && this.prefix.equals(that.getPrefix());
            }
        }
        return false;
    }

    public static Namespace get(String uri) {
        return cache.get(uri);
    }

    public static Namespace get(String prefix, String uri) {
        return cache.get(prefix, uri);
    }

    public short getNodeType() {
        return 13;
    }

    public String getPath(Element context) {
        StringBuffer path = new StringBuffer(10);
        Element parent = this.getParent();
        if (parent != null && parent != context) {
            path.append(parent.getPath(context));
            path.append('/');
        }
        path.append(this.getXPathNameStep());
        return path.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStringValue() {
        return this.uri;
    }

    public String getText() {
        return this.uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String getUniquePath(Element context) {
        StringBuffer path = new StringBuffer(10);
        Element parent = this.getParent();
        if (parent != null && parent != context) {
            path.append(parent.getUniquePath(context));
            path.append('/');
        }
        path.append(this.getXPathNameStep());
        return path.toString();
    }

    public String getXPathNameStep() {
        if (this.prefix != null && !"".equals(this.prefix)) {
            return "namespace::" + this.prefix;
        }
        return "namespace::*[name()='']";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.createHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [Namespace: prefix " + this.getPrefix() + " mapped to URI \"" + this.getURI() + "\"]";
    }
}

